package com.example.sefinsa_app.migrations;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

public class ColocadoraMigration extends SQLiteOpenHelper {

    private static final String NOMBRE_BASE_DE_DATOS = "sefinsa_proyecto2",
    //private static final String NOMBRE_BASE_DE_DATOS = "sefinsa_test",
            NOMBRE_TABLA = "colocadoras";
    private static final int VERSION_BASE_DE_DATOS = 12;

    public ColocadoraMigration(Context context) {
        super(context, NOMBRE_BASE_DE_DATOS, null, VERSION_BASE_DE_DATOS);
        SQLiteDatabase db = this.getWritableDatabase();
    }

    @Override
    public void onCreate(SQLiteDatabase db) {

        String TABLE_SCHEMA = String.format("CREATE TABLE IF NOT EXISTS %s(" +
                        "id integer primary key autoincrement, " +
                        "nombre_completo text, " +
                        "direccion text, " +
                        "telefono text, " +
                        "status text, " +
                        "ruta_id text, " +
                        "poblacion_id text, " +
                        "created_at text, " +
                        "updated_at text) "
                , NOMBRE_TABLA);

        db.execSQL(TABLE_SCHEMA);

    }

    @Override
    public void onUpgrade(SQLiteDatabase sqLiteDatabase, int i, int i1) {
        sqLiteDatabase.execSQL(String.format("DROP TABLE IF EXISTS " + NOMBRE_TABLA));
        onCreate(sqLiteDatabase);

    }

}
